// A version of ClientLookupExample to use filtering

package corejini.chapter10;

import net.jini.lookup.ServiceItemFilter;
import java.io.IOException;

public class ClientLookupWithFiltering extends ClientLookupExample {
    public ClientLookupWithFiltering() throws IOException {
    }
    
    public ServiceItemFilter getFilter() {
	AggregationFilter filt = 
	    new AggregationFilter(AggregationFilter.AND);

        filt.add(new ServiceInfoVendorFilter("Sun"));
        filt.add(new ServiceInfoVersionFilter("1.0", 
	                        ServiceInfoVersionFilter.EQUAL_OR_GREATER));

	return filt;
    }
    
    public static void main(String[] args) {
        try {
            ClientLookupWithFiltering cle =
                new ClientLookupWithFiltering();
            cle.runTests();
        } catch (Exception ex) {
            System.err.println(ex.toString());
        }

	System.exit(0);
    }
        
} 
