// A version of ClientLookupExample that uses events

package corejini.chapter10;

import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.LookupCache;
import java.io.IOException;

public class ClientLookupWithEvents extends ClientLookupExample {
    protected ServiceDiscoveryListener myListener;
    
    public ClientLookupWithEvents() throws IOException {
        System.out.println("Creating with events");
        myListener = new DiffListener();
    }
    
    public ServiceDiscoveryListener getListener() {
        return myListener;
    }
    
    public static void main(String[] args) {
        try {
            ClientLookupWithEvents cle =
                new ClientLookupWithEvents();

            cle.runTests();
        } catch (Exception ex) {
            System.err.println(ex.toString());
        }

	System.exit(0);
    }
} 
