// Explore the ServiceDiscoveryManager

package corejini.chapter10;

import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceItemFilter;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import corejini.chapter9.ServiceInfoSearcher;

public class ClientLookupExample  {
    protected LookupDiscoveryManager discoveryMgr;
    protected LeaseRenewalManager leaseMgr;
    protected ServiceDiscoveryManager lookupMgr;
    
    public ClientLookupExample() throws IOException {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }

        lookupMgr = new ServiceDiscoveryManager(null, null);
    }
    
    // subclasses may override...
    public ServiceDiscoveryListener getListener() {
        return null;
    }
    
    // subclasses may override...
    public ServiceItemFilter getFilter() {
        return null;
    }

    // Do a bit of work here...
    public void runTests() {
	ServiceTemplate tmpl = new ServiceTemplate(null, null, null);
        ServiceItem service = null;

	service = lookupMgr.lookup(tmpl, null);

	if (service == null) {
	    System.out.println("Non-blocking lookup found no services.");
	} else {
	    System.out.print("Non-blocking lookup found: ");
	    ServiceInfoSearcher.printServiceInfo(service);
        }

	try {
	    service = lookupMgr.lookup(tmpl, null, 20000);
	} catch (RemoteException ex) { 
	    System.out.println("Error: " + ex);
	} catch (InterruptedException ex) {
	}

	if (service == null) {
	    System.out.println("Blocking lookup found no services.");
	} else {
	    System.out.print("Blocking lookup found: ");
	    ServiceInfoSearcher.printServiceInfo(service);
        }
      
        LookupCache cache = null;
	
	try {
	    cache = lookupMgr.createLookupCache(tmpl,
				                getFilter(),
				                getListener());
        } catch (RemoteException ex) {
	    System.out.println("Error: " + ex);
	}

        service = cache.lookup(null);
            
        if (service == null) {
            System.out.println("Cache lookup found no services.");
        } else {
            System.out.print("Cache lookup found: ");
            ServiceInfoSearcher.printServiceInfo(service);
        }

	System.out.println("Pausing...");
        try {
            Thread.sleep(5000);
	} catch (Exception ex) {
        }
            
        System.out.println("Trying again...");
        service = cache.lookup(null);
        if (service == null) {
            System.out.println("Cache lookup found no services.");
        } else {
            System.out.print("Cache lookup found: ");
            ServiceInfoSearcher.printServiceInfo(service);
        }

	System.out.println("Getting all cached services...");
        ServiceItem[] services = cache.lookup(null,
                                              Integer.MAX_VALUE);
            
        if (services == null || services.length == 0) {
            System.out.println("No services in cache");
        } else {
            for (int i=0 ; i<services.length ; i++) {
                System.out.print("[" + i + "] ");
                ServiceInfoSearcher.printServiceInfo(services[i]);
            }
        }

	cache.terminate();
    }
    
    public static void main(String[] args) {
        try {
	    ClientLookupExample cle = new ClientLookupExample();
	    cle.runTests();
        } catch (IOException ex) {
            System.err.println(ex.toString());
        }

	System.exit(0);
    }
} 
