// A filter that joins other filters together.

package corejini.chapter10;

import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceItemFilter;
import java.util.ArrayList;
import java.util.Iterator;

public class AggregationFilter implements ServiceItemFilter {
    private ArrayList list = new ArrayList();
    private int operator;

    public static final int AND = 1;	// all must match
    public static final int OR = 2;	// any must match
    
    public AggregationFilter(int operator) {
	if (operator == AND || operator == OR) {
	    this.operator = operator;
	} else {
	    throw new IllegalArgumentException("Bogus operator");
	}
    }

    public void add(ServiceItemFilter filter) {
	list.add(filter);
    }
        
    public boolean check(ServiceItem item) {
	if (list.size() == 0) {
	    return true;
	}

	Iterator iter = list.iterator();

	while (iter.hasNext()) {
	    ServiceItemFilter filter = 
		(ServiceItemFilter) iter.next();

	   boolean result = filter.check(item);

	   if (result && operator == OR) {
	       return true;
	   }

	   if (!result && operator == AND) {
	       return false;
	   }
	}
           
        // If we've made it to the end without shortcutting, then
	// we're in OR and have seen nothing but falses (and should
	// return false), or we're in AND and we've seen nothing but
	// trues (and should return true).
        return (operator == AND);
    }    
} 
