// A server object that implements the NextNumber
// remote interface

package corejini.appendixa;

import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.Naming;
import java.rmi.server.UnicastRemoteObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.MalformedURLException;

public class NextNumberImpl extends UnicastRemoteObject
	implements NextNumber {
    public NextNumberImpl() throws RemoteException {
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
	        new RMISecurityManager());
        }

	try {
            String host = InetAddress.getLocalHost().getHostName();
            String url = "rmi://" + host + "/nextNumber";
	    Naming.rebind(url, this);
	    System.out.println("Server bound to: " + url);
        } catch (UnknownHostException ex) {
	    System.err.println("Couldn't get local host name");
	    System.exit(1);
	} catch (RemoteException ex) {
	    System.err.println("Couldn't contact rmiregistry.");
	    System.err.println("Are you sure you're running rmiregistry?");
	    System.exit(1);
	} catch (MalformedURLException ex) {
	    // Shouldn't happen
	    System.exit(1);
	}
    }

    public int getNextNumber(int n) {
	return n+1;
    }

    public static void main(String[] args) {
	try {
            NextNumberImpl server = new NextNumberImpl();
	} catch (RemoteException ex) {
	    System.err.println("Trouble creating server: " +
			       ex.getMessage());
            ex.printStackTrace();
	}
    }
}
