// A client to test the NextNumber server

package corejini.appendixa;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.NotBoundException;
import java.rmi.Naming;
import java.net.MalformedURLException;

public class NextNumberClient {
    public static void main(String[] args) {
	if (args.length != 1) {
	    System.err.println("Usage: NextNumberClient <url>");
	    System.exit(1);
	}

	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(
		new RMISecurityManager());
	}

	Remote r = null;
	
	try {
	    r = Naming.lookup(args[0]);
        } catch (RemoteException ex) {
	    System.err.println("Couldn't contact registry.");
	    System.err.println("Are you sure you're running rmiregistry?");
	    System.exit(1);
	} catch (NotBoundException ex) {
	    System.err.println("There is no object bound to " + args[0]);
	    System.err.println("Are you sure you ran the server?");
	    System.exit(1);
	} catch (MalformedURLException ex) {
	    System.err.println("The string " + args[0] + 
			       " is not a valid RMI URL");
	    System.err.println("Make sure you use a " +
			       "properly-formatted rmi:// URL");
	    System.exit(1);
	}

	try {

	    if (r instanceof NextNumber) {
		NextNumber nn = (NextNumber) r;
		System.out.println("Next number after 1 is " +
				   nn.getNextNumber(1));
		System.out.println("Next number after 2 is " +
				   nn.getNextNumber(2));
		System.out.println("Next number after 3 is " +
				   nn.getNextNumber(3));
	    } else {
		System.err.println("Uh oh, the name " +
				   args[0] + "isn't a NextNumber");
	    }
	} catch (RemoteException ex) {
	    System.err.println("Couldn't start client: " +
			       ex.getMessage());
            ex.printStackTrace();
	}
    }
}
